function [yUMF,uUMF,yLMF,uLMF]=unionIT2(xUMF1,uUMF1,xLMF1,uLMF1,xUMF2,uUMF2,xLMF2,uLMF2)

%
% [yUMF,uUMF,yLMF,uLMF]=unionIT2(xUMF1,uUMF1,xLMF1,uLMF1,xUMF2,uUMF2,xLMF2,uLMF2)
%
% function to compute the union of two IT2 FSs
%
% J. M. Mendel and Dongrui Wu, Perceptual Computing: Aiding People in Making Subjective Judgments, 
% Wiley-IEEE Press, 2010.
%
% Dongrui WU (dongruiw@usc.edu), 4/19/2009
%
% IF there are eight inputs, then the function implements
% [yUMF,uUMF,yLMF,uLMF]=unionIT2(xUMF1,uUMF1,xLMF1,uLMF1,xUMF2,uUMF2,
% xLMF2,uLMF2), where
% xUMF1: x-coordinates of the UMF of IT2 FS1
% uUMF1: u-coordinates of the UMF of IT2 FS1
% xLMF1: x-coordinates of the LMF of IT2 FS1
% uLMF1: u-coordinates of the LMF of IT2 FS1
% yUMF: y-coordinates of the union
% uUMF: u-coordinates of the union
% yLMF: y-coordinates of the union
% uLMF: u-coordinates of the union
%
% IF there are two inputs, then the function implements
% [yUMF,uUMF,yLMF,uLMF]=unionIT2(A,B), where A and B are 9-point
% representations of IT2 FSs A and B.

if nargin==8
    if length(xUMF1)~=length(uUMF1)
        error('xUMF1 and uUMF1 must have the same length.');
    end
    if length(xLMF1)~=length(uLMF1)
        error('xLMF1 and uLMF1 must have the same length.');
    end
    if length(xUMF2)~=length(uUMF2)
        error('xUMF2 and uUMF2 must have the same length.');
    end
    if length(xLMF2)~=length(uLMF2)
        error('xLMF2 and uLMF2 must have the same length.');
    end
    left=min(xUMF1(1),xUMF2(1));
    right=max(xUMF1(end),xUMF2(end));
elseif nargin==2
    A=xUMF1;
    B=uUMF1;
    xUMF1=A(1:4);
    uUMF1=[0 1 1 0];
    xLMF1=A(5:8);
    uLMF1=[0 A([9 9]) 0];
    xUMF2=B(1:4);
    uUMF2=[0 1 1 0];
    xLMF2=B(5:8);
    uLMF2=[0 B([9 9]) 0];
    left=min(A(1),B(1));
    right=max(A(4),B(4));
else
    error('The number of inputs must be 2 or 8.');
end

yUMF=linspace(left,right,1000);
yLMF=yUMF;

if size(yUMF,1)<size(yUMF,2) % row vector
    uUMF=max([mg(yUMF,xUMF1,uUMF1);mg(yUMF,xUMF2,uUMF2)],[],1);
    uLMF=max([mg(yLMF,xLMF1,uLMF1);mg(yLMF,xLMF2,uLMF2)],[],1);
else % column vector
    uUMF=max([mg(yUMF,xUMF1,uUMF1) mg(yUMF,xUMF2,uUMF2)],[],2);
    uLMF=max([mg(yLMF,xLMF1,uLMF1) mg(yLMF,xLMF2,uLMF2)],[],2);
end   
